

	list      p=12f629, r = dec   ; list directive to define processor

	#include "p12f629.inc"
	#include "main.inc" 
	#include "def.inc" 

	errorlevel  -302	; suppress message 302 from list file

	__CONFIG   _CP_OFF & _CPD_OFF & _BODEN_OFF & _WDT_OFF & _PWRTE_OFF & _FOSC_HS & _MCLRE_ON

	extern	Send_L_Nible, Send_H_Nible, Send_OK
	extern	Init_LCD, Delay250
	extern	Send_LCD_Data, Bin2BCD, Delay
	extern	Bin1, Bin2, Bin3, Bin4, B2Tmp,B3Tmp,B4Tmp
	extern	BCD_1,BCD_2,BCD_3,BCD_4	
	extern	LCD_Bitlen, LCD_Cmd, LCD_DByte

	code

	ORG     0x000       ; processor reset vector
	goto    main        ; go to beginning of program
;#######################################################
;##########		Interrupt		########################
;#######################################################	

	ORG     0x004       

	btfss	INTCON,T0IF		; 2-Cycle if TMR0-IRQ ; 1-Cycle if TMR1-IRQ
	goto	TMR1_IRQ		; 2-Cycle
;***************************************************************
TMR0_IRQ:
	bcf		INTCON,T0IF		; 1-Cycle
	incfsz	B2Tmp,F			; 1 Cycle if NOT Zerro , 2-Cycle if Zerro
	retfie					; 2-Cycle
	incfsz	B3Tmp,F			; 1/2 Cycle
	retfie					; 2-Cycle
	incf	B4Tmp,F			; 1 Cycle
	retfie					; 2-Cycle  , 12 Tcyc inkl. retie
;***************************************************************
TMR1_IRQ:
	bcf		PIR1,TMR1IF		; 1-Cycle 
	decfsz	TMR1_Count,F	; 1/2 Cycle
	retfie 					; 2-Cycle  9-Cycle inkl. retie
	movf	TMR0,W			; 1-Cycle, Save TMR0 value
	movwf	Bin1			; 1 Cycle  up here are 9-Cycle	
	btfsc	INTCON,T0IF
	incf	B2Tmp,F

	bcf		INTCON,T0IF
	bcf		INTCON,T0IE
	bcf		T1CON,TMR1ON
TMR1_1:
	movf	B2Tmp,W
	movwf	Bin2
	clrf	B2Tmp
	movf	B3Tmp,W
	movwf	Bin3
	clrf	B3Tmp
	movf	B4Tmp,W
	movwf	Bin4
	clrf	B4Tmp
	bsf		Bit_Flag,Show_Val
	retfie 
; Osc. 16 MHz
; 4000000 - (65536*61) = 4000000 - 3997696 = 2304
; 65536 - 2304 = 63232 = 0xF700; Reload value
; 9-Tcyc until TMRO saved in Bin1
; 0xF700 - 9 = F6F7 -> new Reload value
;#######################################################
;##########			Main		########################
;#######################################################
;#######################################################
main:
	call	Init_Dev
; prepare Shiftregister
	movlw	0x01			; b'0000.0001'
	movwf	LCD_DByte
	call	Send_LCD_Data
	call	Init_LCD
	bcf		INTCON,GIE	; 0: Disables all interrupts
	call	Cursor_Home
	movlw	Write_LCD		; #define  0x03 ; RS=1 ,E=1
	movwf	LCD_Cmd
	call	Send_OK
	movlw	0x10
	call	Wait_QS		; 1 S wait
	movlw	0x10		; load 16 byte ,2 char to LCD-RAM
	call	Load_CGRAM
	movlw	0x00	
	call	Set_DDRAM_Adr
	call	Load_TMR1_Value		; load Reload value from EEPROM
;#######################################################
;##########		measuring					############
;#######################################################
	clrf	Bit_Flag		; Clear all Flag's
Init_Display:
	call	Clear_Display
	call	Show_LCD_Text
	bcf		Bit_Flag,Mess_Nr	; set measurement number to 0	
	movlw	0x03
	movwf	PS_Curr				; set prescaler TMR0 to 1:16
	call	Set_PS
;*************************************
Mess_start:		
	bsf		STATUS,RP0 		; bank select
	bcf		PIE1,TMR1IE		; TMR1-IRQ Disable
	bcf		STATUS,RP0
	bcf		INTCON,GIE		; Global Interrupt Disable
	bcf		INTCON,T0IE		; TMR0-IRQ Disable
	bcf		INTCON,T0IF		; TMR0-IRQ flag Clear
	bcf		T1CON,TMR1ON	; TMR1 Stop	
	bcf		PIR1,TMR1IF		; TMR1-IRQ flag Clear	
	bsf		STATUS,RP0
	bsf		PIE1,TMR1IE		; TMR1-IRQ Enable
	bcf		STATUS,RP0
	bcf		Bit_Flag,Show_Val	; Clear Show Value, Busy
	bcf		Bit_Flag,Key_Press	; indicate Key pressed
	movlw	0x3E				; dez. 62 (61+reload value)
	movwf	TMR1_Count	
	movf	TMR1_RH,W			; TM1-H reload-wert 
	movwf	TMR1H
	movf	TMR1_RL,W			; TM1-L reload-wert
	movwf	TMR1L
	bsf		INTCON,GIE			; Global Interrupt Enable
	clrf	TMR0				; Clear TMR0 and TMR0-Prescaler
	bsf		INTCON,T0IE			; TMR0-IRQ Enable
	bsf		T1CON,TMR1ON		; TMR1 Start
;;############### measurement Loop 	#########################
Mess_check: 
	btfsc	Bit_Flag,Show_Val	;check end of measurement
	goto	Mess_End
    call	ShowBCDval			
	btfss	GPIO,Key			; check if Key pressed
	goto	Mess_check
	call	Calibration			; Callibration
	goto	Init_Display
Mess_End:
	bcf		INTCON,GIE			; Global Interrupt Disable
	call	Get_BCD				; convert binary to BCD-packt
	btfsc	Bit_Flag,Mess_Nr	; check measurement number
	goto	MessNr_1
MessNr_0:
	bsf		Bit_Flag,Mess_Nr	; set measurement number to 1
	call	Get_PS				; get prescaler value
	call	Show_PS
	goto	Mess_start
MessNr_1:
	bcf		Bit_Flag,Mess_Nr	; set measurement number to 0
	movlw	0x03				; Set Default prescaler  1:16
	movwf	PS_Curr	
	movlw	0x10
	movwf	PS_Count			; for show prescaler at LCD
	call	Set_PS
	goto	Mess_start
;*****************************************************
;#######################################################
;##########		Show BCD-value				############
;#######################################################
ShowBCDval:
	movlw	0x05	
	call	Set_DDRAM_Adr	; Set char position in the LCD	

	bcf 	Bit_Flag,Hide_Zerro		; hide preceding zeros
	movlw	0x04
	movwf	Counter
	movlw 	BCD_4	 		;Get Adress of BCD_4
	movwf	FSR
do_BCD_Digit:
	movf	INDF,W	
	andlw	0xF0
	movwf	sWreg
	swapf	sWreg,W
	call	Check_Zerro	
	movwf	sWreg
	call	Send_H_Nible	
	movf	sWreg,W
	call	Send_L_Nible

	movf	INDF,W	
	andlw	0x0F
	call	Check_Zerro
	movwf	sWreg
	call	Send_H_Nible	
	movf	sWreg,W
	call	Send_L_Nible

	decf	FSR,F
	decfsz	Counter,F
	goto	do_BCD_Digit
	return
;*****************************************************
;#######################################################
;##########		Show chars :"FRQ.:-------- Hz"		####
;#######################################################
Show_LCD_Text:
	movlw	0x1F			; offset adres
	movwf	TableOffset
	movlw	0x05			; number of char;"FRQ.:"
	call	Load_Char
;*****************************************************
;*****************************************************
;show [-HZ] in display, DDRAM-adress = 13; 1.zeile
show_HZ:
	movlw	0x0D			; Set char position in the LCD; column:13	
	call	Set_DDRAM_Adr

	movlw	0x24			; offset adres
	movwf	TableOffset
	movlw	0x03			; number of char;" Hz"
	call	Load_Char

	movlw	0x40			;Set LCD position at the row:2; column:0	
	call	Set_DDRAM_Adr
	call	Clear_Row
	movlw	0x01			; Show delta char
	call	Show_Char
	movlw	'f'			
	call	Show_Char
	movlw	' '	
	call	Show_Char
	movlw	'='			
	call	Show_Char
	movlw	' '	
	call	Show_Char
	movlw	0x00			; Show -/+ char
	call	Show_Char

	movlw	0x48			; Set char position in the LCD; column:8	
	call	Set_DDRAM_Adr

	movlw	0x24
	movwf	TableOffset
	movlw	0x03			; load char's " Hz"
	call	Load_Char
	return

Show_PS:
	movlw	0x46			; Set char position in the LCD; row:2 column:6
	call	Set_DDRAM_Adr

	movf	PS_Count,W
	btfsc	STATUS,Z
	incf	PS_Count,F
	btfss	PS_Count,4
	goto	Show_PS1
	movlw	0x06
	iorwf	PS_Count,F
Show_PS1:
	bcf		Bit_Flag,Show_Dir	; Down direction
	movlw	0x01
	movwf	Counter
	movlw 	PS_Count
	movwf	FSR 			
	call	Show_Reg
	return
;#######################################################
;#########	Set OPTION_REG  			################
;#######################################################			
Set_PS:	 	
	bsf		STATUS,RP0 		; ###### (set bank 1) ######
	movlw	b'11110000'		; PS_Count Maske
	andwf	OPTION_REG,F
	movf	PS_Curr,W
	iorwf	OPTION_REG,F
	bcf		STATUS,RP0 		; ###### (set bank 0) ######
	return
;#######################################################
;#########	Bin to BCD value			################
;#######################################################
Get_BCD:
	bsf		STATUS,RP0
	btfsc	OPTION_REG,PSA	; PSA:1 -> No-Prescaler
	goto	Multi_End		; No-Prescaler -> No-Multiplication
	movf	PS_Curr,W
	addlw	0x01
	movwf	Counter
Do_Multi:
	bcf		STATUS,C
	rlf		Bin1,F		; Multiplication of  2
	rlf		Bin2,F
	rlf		Bin3,F
	rlf		Bin4,F
	decfsz	Counter,F
	goto	Do_Multi
Multi_End:
	bcf		STATUS,RP0
	movlw 	0x20		; number of shifting; 32 bit = 4 Byte
	call	Bin2BCD		; Get BCD_Packet
	return
;#######################################################
;##########		Calibration		########################
;#######################################################	
Calibration:
	bcf		INTCON,GIE
Cal_Menu:	
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	call	Clear_Display
	call	Cursor_Home
	movlw	0x27
	movwf	TableOffset
	movlw	0x0F
	call	Load_Char
	
	movlw	0x10
	call	Wait_QS		; 1S  wait	
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
; dt	"Cancel ?"			; 8  char, offset:0x36
Cal_Cancel:
	movlw	0x40
	call	Set_DDRAM_Adr
	call	Clear_Row		; clear LCD row-2
	movlw	0x43			; set char position	row:2; col.:3
	call	Set_DDRAM_Adr
	movlw	0x36
	movwf	TableOffset
	movlw	0x08
	call	Load_Char
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	bcf		Bit_Flag,Key_Press		;  Preaper Key-flag
	call	Check_Key				; Check KEY pressed
	btfsc	Bit_Flag,Key_Press	
	return				
		
;<<<<<<<<<<<<<<<< MenuUpDown: <<<<<<<<<<<<<<<<<<<<<<<<<<<<<
; dt	"Up ?"			; 4  char, offset:0x49
Cal_Up:	
	clrf	dummy
	movlw	0x40
	call	Set_DDRAM_Adr
	call	Clear_Row		; clear LCD row-2
Cal_Up1:
	movlw	0x43			; set char position	row:2; col.:3
	call	Set_DDRAM_Adr
	movlw	0x44
	movwf	TableOffset
	movlw	0x04
	call	Load_Char
;;;<<<<<<<<<<<<<<<<<
Up_Key:
	bcf		Bit_Flag,Key_Press
	call	Check_Key
	btfss	Bit_Flag,Key_Press
	goto	Cal_Down
	call	Menu_Up
	goto	Up_Key		
;;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
; dt	"Down ?"		; 6 char, offset:0x3E
Cal_Down:
	clrf	dummy
	movlw	0x40			
	call	Set_DDRAM_Adr	
	call	Clear_Row		; clear LCD row-2
Cal_Down1:
	movlw	0x43			; set char position	row:2; col.:3
	call	Set_DDRAM_Adr
	movlw	0x3E
	movwf	TableOffset
	movlw	0x06
	call	Load_Char
;;;<<<<<<<<<<<<<<<<<<
Down_Key:
	bcf		Bit_Flag,Key_Press
	call	Check_Key
	btfss	Bit_Flag,Key_Press
	goto	Cal_Cancel
	call	Menu_Down	
	goto	Down_Key			
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
Menu_Up:
	; Timer Decrementieren, zeitbasis vefgrossen
	; Frq.in ist klein
	decf	TMR1_RL,F		; decrement TMR1L-Value
	movf	TMR1_RL,W
	xorlw	0xFF
	btfsc	STATUS,Z
	decf	TMR1_RH,F		; decrement TMR1H-Value
	call	Save_Cal		
	movlw	0x46			; row-2 ; col.:6	
	call	Set_DDRAM_Adr
	incf	dummy,f
	movf	dummy,W
	call	Byte2BCD
	movlw	0x46			; row-2 ; col.:6
	call	Set_DDRAM_Adr
	movlw	'+'			
	call	Show_Char
	return
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
Menu_Down:
	; Timer Incrementieren, zeitbasis vefkleinern
	; Frq.in ist Hoch
	incf	TMR1_RL,F		; Increment TMR1L-Value
	btfsc	STATUS,Z
	incf	TMR1_RH,F		; Increment TMR1H-Value
	call	Save_Cal
	movlw	0x48			; row-2 ; col.:8
	call	Set_DDRAM_Adr
	incf	dummy,f
	movf	dummy,W
	call	Byte2BCD

	movlw	0x48			; row-2 ; col.:8
	call	Set_DDRAM_Adr	
	movlw	'-'			
	call	Show_Char
	return
;#######################################################
;##########		Check Key for ca. 2 S	################
;#######################################################	
Check_Key:
	movlw	0x64		; 100*10mS= 1S
	movwf	Counter
Check_Key_1:
	movlw	0x28		; wait for ca. 40*250S=10 mS
	movwf	Delay
	call	Delay250	
	
	btfsc	GPIO,Key	; jump wenn Key NOT pressed
	goto	Key_Pressed
	decfsz	Counter,F
	goto	Check_Key_1
	return
Key_Pressed:
	bsf		Bit_Flag,Key_Press		; Key-Pressed
Check_Key_2:
	movlw	0x28
	movwf	Delay
	call	Delay250		; wait for ca. 10 ms	
	btfsc	GPIO,Key		; wait until Key Release
	goto	Check_Key_2
	return

;#################################################
;####	conver one Byte to BCD-packet		######
;####	Byte is in the W-reg				######
;#################################################
Byte2BCD:
	movwf	Bin4
	clrf	Bin3
	clrf	Bin2
	clrf	Bin1
	
	bsf 	Bit_Flag,Hide_Zerro
	movlw 	0x08			; number of shifting
	call	Bin2BCD
	movlw	0x02
	movwf	Counter
	movlw 	BCD_2	 		;Get Adress of BCD_4
	movwf	FSR
do_Digit:
	movf	INDF,W	
	andlw	0xF0
	movwf	sWreg
	swapf	sWreg,W
	call	Check_Zerro	
	movwf	sWreg
	call	Send_H_Nible	
	movf	sWreg,W
	call	Send_L_Nible

	movf	INDF,W	
	andlw	0x0F
	call	Check_Zerro
	movwf	sWreg
	call	Send_H_Nible	
	movf	sWreg,W
	call	Send_L_Nible

	decf	FSR,F
	decfsz	Counter,F
	goto	do_Digit
	return
;#######################################################
;#####			Save Callibration Value				####
;#####	callibration value in the 0x7E und 0x7F		####
;#######################################################
Save_Cal:
	bsf		STATUS,RP0
	movlw	0x7E
	movwf	EEADR
	movf	TMR1_RH,W
	movwf	EEDATA
	call	WriteEEPROM
	bsf		STATUS,RP0
	movlw	0x7F
	movwf	EEADR
	movf	TMR1_RL,W
	movwf	EEDATA
	call	WriteEEPROM
	bcf		STATUS,RP0
	return	

;#######################################################
;##				Show content of Register's			  ##
;## number of Register in Counter					  ##
;## Adress in FSR									  ##
;## Bit_Flag,Show_Dir:1 Up Direction Count			  ##
;## Bit_Flag,Show_Dir:0 Down Direction Count		  ##
;#######################################################
Show_Reg:
	movf	INDF,W	
	andlw	0xF0			
	movwf	sWreg
	swapf	sWreg,F
	movf	sWreg,W
	call	Check_Char
	call	Send_H_Nible	
	movf	sWreg,W
	call	Send_L_Nible

	movf	INDF,W	
	andlw	0x0F			
	movwf	sWreg
	call	Check_Char
	call	Send_H_Nible	
	movf	sWreg,W
	call	Send_L_Nible

	btfss	Bit_Flag,Show_Dir
	goto	Down_Direction
	incf	FSR,F
	goto	Show_Dec
Down_Direction:
	decf	FSR,F
Show_Dec:
	decfsz	Counter,F
	goto	Show_Reg
	return
;#######################################################
;##########		Check if ASC or Zahl	################
;#######################################################
Check_Char:
	sublw	0x09
	btfsc	STATUS,C	
	goto 	number
	movf	sWreg,W
	addlw	0x37			; add offset fr ASCII (A...F)
	movwf	sWreg
	return
number:
	movf	sWreg,W
	addlw	0x30			; add offset fr ASCII	(0...9)
	movwf	sWreg
	return
 
;#######################################################
;##########	Check und Clear previous zeros			####
;#######################################################
Check_Zerro:
	btfsc	Bit_Flag,Hide_Zerro	
	goto	C_Z
	btfsc	STATUS,Z
	retlw	0x20
	bsf		Bit_Flag,Hide_Zerro
C_Z:
	addlw	0x30			; add offset fr ASCII	
	return 
;#######################################################
;##########		Check und Save Prescaler 		########
;#######################################################
Get_PS:
; Interne Osc. hat +-2% abweichung im bereich 0...85
; ------------------------------------------------------
; Oscilator 16 MHz, T cyc = 250nS	
; Maximale Inputfrequency, fin with Duty=0,5
; PS:NO -> 3,4 MHz			0|3 4|4 8|2 7|5		0 ... 3,44  MHz  maximal
; PS:2	-> 6,8 MHz			0|6 8|9 6|5 5|1		3,44 ... 6,89 MHz
; PS:4	-> 13,7 MHz			1|3 7|9 3|1 0|3		6,89 ... 13,79 MHz
; PS:8	-> 27,5 MHz			2|7 5|8 6|2 0|6		13,79 ... 27,58 MHz
; PS:16	-> 51,1 MHz			5|1 1|7 2|4 1|3		27,58 ... 55,17 MHz
; if Duty = 30% ... 70% -> max. input frq. is 2068965 Hz
; TMR0 delay: 4*Tosc+40 nS
; if we take a duty of  0,23 ... 0,77, dann input frq. = 
; PS:NO 	-> 1,5 MHz			0|1 5|x x|x x|x		0 ... 1,5  MHz maximal
; PS=0:1:2	-> 6,5 MHz			0|6 5|x x|x x|x		1,5 ... 6,5 MHz
; PS=1:1:4	-> 13,7 MHz			1|3 5|x x|x x|x		6,5 ... 13,5 MHz
; PS=2:1:8	-> 27,5 MHz			2|7 5|x x|x x|x		13,5 ... 27,5 MHz
; PS=3:1:16	-> 51,1 MHz			5|1 1|7 2|4 1|3		27,5 ... 55,17 MHz
;; 
	bcf		STATUS,RP0
	bcf		INTCON,GIE		; Interrupt Disable,

	movlw	0x03		; PS = 011 = 1:16
	movwf	PS_Curr		; Initial PS_Count = 16
	movlw	0x10
	movwf	PS_Count
	
; fin 	0 ... 1,5 MHz, 0|1 5|x x|x x|x, PS:No, 
	movlw	BCD_4
	movwf	FSR
	movlw	0x01		; 0 ... 1,5 MHz
	call	Compare		; Output:[C:0] -> BCD_4 und BCD_3 < 3,5
	btfss	STATUS,C	; Output:[C:1] -> BCD_4 und BCD_3 >= 3,5
	goto	No_PS

; fin 	1,5 ... 6,5 MHz, 0|6 5|x x|x x|x, PS:0 = 1:2,  	
	movlw	BCD_4
	movwf	FSR
	movlw	0x06		; 1,5 ... 6,5 MHz
	call	Compare		; Output:[C:0] -> BCD_4 und BCD_3 < 6,5
	btfss	STATUS,C	; Output:[C:1] -> BCD_4 und BCD_3 >= 6,5
	goto	PS_2
	
; fin 	6,5 ... 13,5 MHz, 1|3 5|x x|x x|x, PS:1 = 1:4, 					
	movlw	BCD_4
	movwf	FSR
	movlw	0x13		; 6,5 ... 13,5 MHz
	call	Compare		; Output:[C:0] -> BCD_4 und BCD_3 < 13,5
	btfss	STATUS,C	; Output:[C:1] -> BCD_4 und BCD_3 >= 13,5
	goto	PS_4
; fin 	13,5 ... 27,5 MHz, 2|7 5|x x|x x|x, PS:2 = 1:8,
	movlw	BCD_4
	movwf	FSR
	movlw	0x27		; 13,5 ... 27,5 MHz
	call	Compare		; Output:[C:0] -> BCD_4 und BCD_3 < 27
	btfss	STATUS,C	; Output:[C:1] -> BCD_4 und BCD_3 >= 27
	goto	PS_8
; fin 	27,5 ... 50,0 MHz, 2|7 5|x x|x x|x, PS:3 = 1:16,
	goto	PS_16
No_PS:	
	bsf		STATUS,RP0 		; ###### (set bank 1) ######
	bsf		OPTION_REG,PSA	; Prescaler assigned to the WDT(WDT is OFF)
	movlw	0x00
	movwf	PS_Curr
	movlw	0x00
	movwf	PS_Count

	bsf		STATUS,RP0 		; ###### (set bank 1) ######
	movlw	b'11111000'		; PS Maske
	andwf	OPTION_REG,F
	movf	PS_Curr,W
	iorwf	OPTION_REG,F

	goto	PS_End	
PS_2:
	decf	PS_Curr,F	; PS:0 -> 1:2
	bcf		STATUS,C
	rrf		PS_Count,F	; 
PS_4:
	decf	PS_Curr,F	; PS:1 -> 1:4
	bcf		STATUS,C
	rrf		PS_Count,F
PS_8:
	decf	PS_Curr,F	; PS:2 -> 1:8
	bcf		STATUS,C
	rrf		PS_Count,F
PS_16:	
	bsf		STATUS,RP0 		; ###### (set bank 1) ######
	bcf		OPTION_REG,PSA	; PS_Count assigned to the TIMER0
	movlw	b'11111000'		; PS_Count Maske
	andwf	OPTION_REG,F
	movf	PS_Curr,W
	iorwf	OPTION_REG,F
PS_End:
	bcf		STATUS,RP0 		;######(set bank0) ###########
	return
;#######################################################
;##########			comparison			################
;##	 compare value in W-reg							  ##
;##	 Byte in the SFR								  ##
;#######################################################
Compare:
	subwf	INDF,W		; FSR = BCD_4
	btfss	STATUS,C
	return				; C:[0] -> Byte > 0, 
	btfss	STATUS,Z	; C:[1] -> W =< Byte
	return				; Z[0] & C:[1] -> W < Byte		
	decf	FSR,F		; Z[1] & C:[1] -> W = Byte
	movlw	0x50
	subwf	INDF,W
	return
;#######################################################
;##########			Wait 1 second			############
;#######################################################
Wait_QS:
	movwf	Counter		; Counter=1 -> 63,75 mS
WQ_loop:
	movlw	0xFF
	movwf	Delay		
	call	Delay250
	decfsz	Counter,F
	goto	WQ_loop
	return

;#####################################################
;####			Send Charakter to LCD			  ####
;##	 Char in Wreg									##
;#####################################################
Show_Char:
	movwf	sWreg
	call	Send_H_Nible
	movf	sWreg,W
	call	Send_L_Nible
	return
;#######################################################
;##########		Cursor_Home		########################
;#######################################################	
Cursor_Home:
; Cursor home: b'0-0-0-0-0-0-1-x'	und Set DDRAM Adres to 0x00
;	movlw	B'0000.0010'	;delay: 1,53 mS
; Send High-Nible
; date in Shiftregister: MSB:D7-D6-D5-D4-RS-E=1:LSB ; b'xx0000.01'
	movlw	0x01			; b'xx.00.0001', High-Nible + RS-E=1
	movwf	LCD_DByte
	call	Send_LCD_Data
; Send Low-Nible	
; date in Shiftregister: MSB:D7-D6-D5-D4-RS-E=1:LSB ; b'xx0010.01'
	movlw	0x09			; b'xx.0000.1001', Low-Nible + RS-E=1
	movwf	LCD_DByte	
	call	Send_LCD_Data

	movlw	0x08
	movwf	Delay
	call	Delay250		; ca. 2 mS wait
	return
;#######################################################
;##########		Clear Display	########################
;## Write 0x20 to DDRAM and set DDRAM Adres to AC:0x00 #
;## b'00000001' + RS:0, RW:0 #define Set_LCD 0x00   ####
;#######################################################
Clear_Display:
; Send High-Nible
; date in Shiftregister: MSB:D7-D6-D5-D4-RS-E=1:LSB ; b'xx0000.01'
	movlw	0x01			; b'xx.00.0001', High-Nible + RS-E=1
	movwf	LCD_DByte
	call	Send_LCD_Data
;; Send Low-Nible		
; date in Shiftregister: MSB:D7-D6-D5-D4-RS-E=1:LSB ; b'xx0001.01'
	movlw	0x05			; b'xx00.0101', Low-Nible + RS-E=1
	movwf	LCD_DByte	
	call	Send_LCD_Data

	movlw	0x08
	movwf	Delay
	call	Delay250		; ca. 2 mS wait
	return
;#######################################################
;##########		EEPROM WRITE	########################
;#######################################################
;To write an EEPROM data location, the user must first
;write the address to the EEADR register and the data
;to the EEDATA register.
WriteEEPROM:
	bsf		STATUS,RP0		; ###### (set bank 1) ######
	bsf		EECON1,WREN		;Enable write
	bcf		INTCON,GIE		;Disable INTs
	movlw	0x55 			;Unlock write
	movwf	EECON2          ;
	movlw	0xAA       		;
	movwf	EECON2    		;
	bsf		EECON1,WR		;Start the write
;	bsf		INTCON,GIE		;Enable INTS
	bcf		STATUS,RP0		; ###### (set bank 0) ######
	btfss	PIR1,EEIF		; Poll Interrupt flag
	goto	$-1
	bcf		PIR1,EEIF

;#######################################################
;##########		WRITE VERIFY	########################
;#######################################################
	bsf		STATUS,RP0		; ###### (set bank 1) ######
	movf	EEDATA,W		;EEDATA not changed	;from previous write
	bsf		EECON1,RD 		;YES, Read the  ;value written
	xorwf	EEDATA,W
	btfss	STATUS,Z		;Is data the same
	call	Write_ERR		;No, handle error: ;Yes, continue
	bcf		STATUS,RP0		; ###### (set bank 0) ######
	return
;#######################################################
;##########			EEPROM READ		####################
;#######################################################
;To read a data memory location, the user must write
;the address to the EEADR register and then set
;control bit RD
ReadEEPROM:
	bsf		STATUS,RP0		; set bank 1 
	movwf	EEADR    		; address to read
	bsf     EECON1,RD 		; EE read
	movf	EEDATA,W 		; move data to w	
	bcf		STATUS,RP0		; set bank 0 
	return
;#######################################################
;##########			EEPROM ERROR	####################
;#######################################################
Write_ERR:
	movlw	0x40		; set LCD position to row-2	
	call	Set_DDRAM_Adr
	call	Clear_Row
	movlw	0x10		; dt "ERROR: Write EE"; 15 char; offset:0x10
	movwf	TableOffset
	call	Table_RD
	return
;#######################################################
;##########		Read TMR0 Reload		################
;#######################################################
; lade TMR1 Reload Value HIGH:LOW Value
Load_TMR1_Value:
	movlw	0x7E		;TMR1_Reload HIGH Value Adress
	call	ReadEEPROM
	movwf	TMR1_RH
	movlw	0x7F		;TMR1_Reload LOW Value Adress
	call	ReadEEPROM
	movwf	TMR1_RL
	return	

;#####################################################
;##			Load Byte in der LCD CGRAM Area			##
;#####################################################
; plus-minus,offset:0x00
; delta,offset:0x08
Load_CGRAM:
	movwf	Counter
	movlw	0x00			; offset:0x00
	movwf 	TableOffset 	
	movlw	0x00
	movwf	CGRAM_Adr		; CG-RAM adress = 0x00
Do_load:
	call	Set_CGRAM_Adr	; Set CGRAM Adress
		
	call	Table_RD
	movwf	sWreg
	call	Send_H_Nible
	movf	sWreg,W
	call	Send_L_Nible
	incf	CGRAM_Adr,F
	incf	TableOffset,F
	decfsz	Counter,F
	goto	Do_load
	return
;#####################################################
;##			Load Char from Programm Memory			##
;##  number of char in W-reg						##
;#####################################################
Load_Char:
	movwf	Counter			
Do_char:
	call	Table_RD
	movwf	sWreg
	call	Send_H_Nible
	movf	sWreg,W
	call	Send_L_Nible
	incf	TableOffset,F
	decfsz	Counter,F
	goto	Do_char
	return
;#####################################################
;##				Clear LCD Row						##
;#####################################################
Clear_Row:
	movlw	0x10
	movwf	Counter
Do_CLR:
	movlw	' '
	call	Show_Char
	decfsz	Counter,F
	goto	Do_CLR
	movf	DDRAM_Adr,W
	call	Set_DDRAM_Adr
	return

;#####################################################
;##				Set LCD-DDRAM Adress				##
;#####################################################
Set_DDRAM_Adr:
	movwf	DDRAM_Adr
	movlw	Set_LCD
	movwf	LCD_Cmd
	movlw	0x7F
	andwf	DDRAM_Adr,F
	movlw	0x80
	iorwf	DDRAM_Adr,W
	movwf	sWreg
	call	Send_H_Nible	
	movf	sWreg,W
	call	Send_L_Nible
; 
	movlw	Write_LCD
	movwf	LCD_Cmd
	return
;#####################################################
;##				Set CGRAM Adress					##
;#####################################################
Set_CGRAM_Adr:
	movlw	Set_LCD
	movwf	LCD_Cmd
	movlw	0x3F
	andwf	CGRAM_Adr,F
	movlw	0x40
	iorwf	CGRAM_Adr,W
	movwf	sWreg
	call	Send_H_Nible	
	movf	sWreg,W
	call	Send_L_Nible
	movlw	Write_LCD
	movwf	LCD_Cmd
	return
;#######################################################
;##########		Init Device		########################
;#######################################################
Init_Dev:	
; alle register in (bank 0) default(reset) ist RB0=0 -> bank 0
	bcf     STATUS,RP0      ; set bank 0
	movlw 	0x07		 	
	movwf 	CMCON 			; Comparator Off
; T1CON :	x TMR1GE T1CKPS1 T1CKPS0 T1OSCEN T1SYNC TMR1CS TMR1ON
;	0x04		x   0      0       0       0       1      0      0
	movlw	0x04
	movwf	T1CON
	bcf		INTCON,T0IE		; TMR0-IRQ Enable
	bsf		INTCON,PEIE		; Peripheral Interrupt Enable

	bsf		STATUS,RP0 		; set bank 1
	bcf		TRISIO,0		; GP0:Pin7 output
	bsf		TRISIO,1		; GP1:Pin6 Input;Key

; OPTION_REG :	GPPU INTEDG T0CS T0SE PSA PS2 PS1 PS0
;	0xE5			 1     1     1     0   0   0   1   1
	movlw	0x03			; 1:16
	movwf	PS_Curr
	movlw	0xE0			; b'11100000'
	iorwf	PS_Curr,W
	movwf	OPTION_REG
	movlw	0x10
	movwf	PS_Count
	bcf		STATUS,RP0 		; set bank 0	
	return
	
;#######################################################
;######### 			Table Read 		####################
;#######################################################
Table_RD:
	movlw 	HIGH Table
	movwf 	PCLATH
	movf 	TableOffset,W 	;load offset in w reg
	call 	Table
	return
;#######################################################
;######### 			Byte of char		################
;#######################################################
	org	0x3B0	
Table:
	addwf PCL,F
	dt	0x04,0x04,0x1F,0x04, 0x04,0x00,0x1F,0x00 ;-/+ char; offset:0x00
	dt	0x00,0x04,0x0A,0x0A, 0x11,0x11,0x1F,0x00 ;delta; offset:0x08
	dt	"ERROR: Write EE"	; 15 char, offset:0x10
	dt	"FRQ.: Hz"			; 8  char, offset:0x1F
	dt	"< Calibration >"	; 15 char, offset:0x27	
	dt	"Cancel ?"			; 8  char, offset:0x36
	dt	"Down ?"			; 6  char, offset:0x3E
	dt	"Up ?"				; 4  char, offset:0x44

;#######################################################
;######### 		Init EEPROM		########################
;#######################################################
; initialize eeprom locations	; START=0x2100	END=0x217F
; the last 2 Byte's are Reload value for TMR1: TMR1H + TMR1L
	ORG	0x217E
	DE	0xF6, 0xF7	; H-Value, L-Value
		
;########################################################################
	END
