
	#include "p12f629.inc"
	#include "lcd.inc" 
	#include "def.inc" 


	extern	Counter
	global	LCD_Bitlen, LCD_DByte, LCD_Cmd, Delay  	
	global	Send_LCD_Data, Init_LCD
	global	Init_LCD, Delay250
	global	Send_L_Nible, Send_H_Nible, Send_OK

	
	code
;#############################################################
;##			Send LCD_DByte to Shiftregister					##
;#############################################################
Send_LCD_Data: 
	bsf		GPIO,LCD_DLine	; GP0(Pin7) Set HIGH
	movlw	0x06			; 6-Bit(74LS174), b'xxddddcc'
	movwf	LCD_Bitlen		; Nummber of Bit to Scroll
	bcf		STATUS,C
Send_do:
	bcf		GPIO,LCD_DLine		; GP0(Pin7) set LOW	
	rrf		LCD_DByte,f			; 1.bit in Carry
	bcf		GPIO,LCD_DLine		; GP0(Pin7) set LOW	
	btfss	STATUS,C
	call	tau6_delay			; Bit=0 -> 6tau delay
	bsf		GPIO,LCD_DLine		; GP0(Pin7)Set HIGH 
 
	call	tau6_delay			; 6tau delay between Bit's
	
	decfsz	LCD_Bitlen,f
	goto	Send_do

	call	tau6_delay
	return

;#############################################################
;##						6 tau delay							##
;#############################################################
tau6_delay:
	movlw	0x50		; 80*3Tcy=80*0,75S=60S
	movwf	Delay
tau6_do:	
	decfsz	Delay,F
	goto	tau6_do
	return	

;#############################################################
;##				Send_H_Nible								##
;##	 Nible in the W-reg										##
;#############################################################
Send_H_Nible:
	andlw	0xF0
	movwf	LCD_DByte
	bcf		STATUS,C
	rrf		LCD_DByte,f
	rrf		LCD_DByte,f
	movf	LCD_Cmd,W
	iorwf	LCD_DByte,f	
	call	Send_LCD_Data
	return
;#############################################################
;##				Send_L_Nible								##
;##	 Nible in the W-reg										##
;#############################################################
Send_L_Nible:
	andlw	0x0F
	movwf	LCD_DByte
	bcf		STATUS,C
	rlf		LCD_DByte,f
	rlf		LCD_DByte,f
	movf	LCD_Cmd,W
;	movlw	Write_LCD
	iorwf	LCD_DByte,f	
	call	Send_LCD_Data
	return

;#############################################################
;##					Init_LCD								##
;#############################################################
Init_LCD:
;  wait for ca. 50 mS after Vcc rises to 4.5V
	movlw	0xC8		; wait for ca. 50 mS
	movwf	Delay
	call	Delay250	

	movlw	0x0D			; b'000011.01'
	movwf	LCD_DByte
	call	Send_LCD_Data
	
	movlw	0x14			; wait for ca. 5 mS
	movwf	Delay
	call	Delay250
; 	
	movlw	0x0D			; b'000011.01'
	movwf	LCD_DByte
	call	Send_LCD_Data
	
	movlw	0x04			; wait for ca. 1 mS
	movwf	Delay
	call	Delay250
;	
	movlw	0x0D			; b'000011.01'
	movwf	LCD_DByte
	call	Send_LCD_Data
	
	movlw	0x01			; wait for ca. 250 S
	movwf	Delay
	call	Delay250
;------------------------------------------------------
; RS R/W DB7 DB6 DB5 DB4  DB3 DB2 DB1 DB0
; 0 - 0 [ 0   0   1   DL - N   F   x   x ] FUNCTION SET 
; DL=0: 4-bit Mode	DL=1: 8-bit Mode
; N=0: 1-line		N=1: 2-line
; F=0: 5x8 Matrix	F=1: 5x11 Matrix			
;-------------------------------------------------------
; date in Shiftregister: MSB:D7-D6-D5-D4-RS-E=1:LSB ; b'xx0010.01'
	movlw	0x09			; b'xx0010.01' MSB:< High-Nible - RS:0 - E:1 >:LSB
	movwf	LCD_DByte
	call	Send_LCD_Data	; b'xx.0010.00'
	
	movlw	0x01
	movwf	Delay
	call	Delay250		; 250 S wait

; DL=0 4Bit, N=1 2xLine , F=0 5x7 Matrix
; Send High-Nible	B'0010.1000'
	movlw	0x09		; b'xx00.1001'
	movwf	LCD_DByte
	call	Send_LCD_Data
; Send Low-Nible	B'0010.1000'
	movlw	0x21		 ; b'xx10.0001' ,
	movwf	LCD_DByte
	call	Send_LCD_Data	

	movlw	0x08			; wait  2 mS
	movwf	Delay
	call	Delay250	
;------------------------------------------------------------------	
; Clear display: b'0-0-0-0-0-0-0-1'	 Time:1,53 mS
; Display clear and set DDRAM Adres 0x00
; Send High-Nible
	movlw	0x01			; b'xx.00.0001'
	movwf	LCD_DByte		
	call	Send_LCD_Data
; Send Low-Nible
	movlw	0x05			; b'xx.00.0101'
	movwf	LCD_DByte		
	call	Send_LCD_Data	

	movlw	0x08
	movwf	Delay
	call	Delay250		; ca. 2,01 mS warten
;-----------------------------------------------------------------
; Mode Set: b'0-0-0-0-0-1-I/D-S'	;  Time:40 S
; I/D=0: links(Increment)		I/D=1: rechts(Decrement) 
; S=0: kein Display-shift		S=1: Display-shift ein 
; b'00000110'
; Send High-Nible
	movlw	0x01			; b'xx.00.0001'
	movwf	LCD_DByte
	call	Send_LCD_Data
; Send Low-Nible		
	movlw	0x19			; b'xx01.1001'
	movwf	LCD_DByte	
	call	Send_LCD_Data	

	movlw	0x01
	movwf	Delay
	call	Delay250		; wait 250 S
;------------------------------------------------------------------	
; Cursor home: b'0-0-0-0-0-0-1-x'	und Set DDRAM Adres to 0x00
; Time:1,53 mS
; B'00000010'	;
; Send High-Nible
	movlw	0x01			; b'xx.00.0001'
	movwf	LCD_DByte		
	call	Send_LCD_Data
; Send Low-Nible
	movlw	0x09			; b'xx00.1001'
	movwf	LCD_DByte	
	call	Send_LCD_Data	
	
	movlw	0x08
	movwf	Delay
	call	Delay250		; wait 2 mS
;-------------------------------------------------------------------	
; Display on: b'0-0-0-0-1-D-C-B'	; bentigte Time:40 S
;D=0: Display aus	D=1: Display ein 
;C=0: Kursor aus	C=1: Kursor ein
;B=0: Kursor als Unterstrich		B=1: Kursor als blinkender Block 

; Send High-Nible
; b'0000.01' MSB:<High-Nible + RS + E=1>:LSB
	movlw	0x01			; b'xx00.0001'
	movwf	LCD_DByte
	call	Send_LCD_Data
; Send Low-Nible
	movlw	0x31			; b'xx11.0001'
	movwf	LCD_DByte
	call	Send_LCD_Data

	movlw	0x01			; 250 S warten
	movwf	Delay
	call	Delay250

	return

;#############################################################
;##					Delay of 250 S							##
;## Interne Osz=16 MHz --> fcyc = 4 MHz --> Tcyc= 250 nS	##
;## delay Value in WREG !=0									##
;#############################################################
Delay250: 					
	movlw	0xFA
	movwf	Delay1
LoopDX:
	nop
	decfsz	Delay1,f
	goto 	LoopDX
	decfsz	Delay,f
	goto 	Delay250
	return

;#########################################################
;##						Send_OK							##
;#########################################################
Send_OK:
	movlw	'O'					; 0x4F = d79 = b'0100,1111'
	call	Send_H_Nible
	movlw	'O'
	call	Send_L_Nible

	movlw	'K'					; 0x4B = d75 = b'01001011'
	call	Send_H_Nible
	movlw	'K'
	call	Send_L_Nible

	movlw	'Y'					; 0x59 = d89 = b'01011001'
	call	Send_H_Nible
	movlw	'Y'
	call	Send_L_Nible
	return

;######################################################
	END

