	
	#include "p12f629.inc"
	#include "bcd_dez.inc"

	global	Bin2BCD
	extern	sWreg, Counter


	code
;#########################################################
;##				Biner to BCD-packted					##
;## 32 Bit to BCD , 4.294.967.295 = 0xFFFFFFFF			##
;## number of shifting in the W-reg						##
;##########################################################
Bin2BCD:	

	movwf 	Counter 	; set count = 32
	clrf	BCD_1
	clrf	BCD_2
	clrf	BCD_3
	clrf	BCD_4
loopBCD:
	bcf		STATUS,C
	rlf 	Bin1,f
	rlf 	Bin2,f
	rlf 	Bin3,f
	rlf 	Bin4,f
	rlf 	BCD_1,f
	rlf 	BCD_2,f
	rlf 	BCD_3,f
	rlf 	BCD_4,f
loopBCD_t:
	decf 	Counter,f
	btfsc	STATUS,Z
	return
	movlw 	0x1A		; only 26-bit effective shifting
	bcf		STATUS,C
	subwf	Counter,W
	btfsc	STATUS,C
	goto	loopBCD

adjDEC:
	movlw 	BCD_1	; load address BCD_1
	movwf 	FSR
	call 	adjBCD	
	incf 	FSR,f	; BCD_2
	call 	adjBCD	
	incf 	FSR,f	; BCD_3
	call 	adjBCD	
	incf 	FSR,f	; BCD_4
	call 	adjBCD		
	goto 	loopBCD

adjBCD:
	movf  	INDF,w
	addlw 	0x03
	movwf   sWreg
	btfsc 	sWreg,3
	movwf 	INDF
	movf  	INDF,w
	addlw 	0x30
	movwf   sWreg
	btfsc 	sWreg,7
	movwf 	INDF
	return

;;####################################################

	END
